% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.R
\name{cpa}
\alias{cpa}
\title{Criterion-Related Profile Analysis}
\usage{
cpa(formula, data, k = 100, na.action = "na.fail", family = "gaussian",
  weights = NULL)
}
\arguments{
\item{formula}{An object of class \code{\link{formula}} of the form \code{response ~ terms}.}

\item{data}{An optional data frame, list or environment containing the variables in the model.}

\item{k}{Corresponds to the scalar constant and must be greater than 0. Defaults to 100.}

\item{na.action}{How should missing data be handled? Function defaults to failing if missing data are present.}

\item{family}{A description of the error distribution and link function to be used in the model. See \code{\link{family}}.}

\item{weights}{An option vector of weights to be used in the fitting process.}
}
\value{
An object of class \code{critpat} is returned, listing the following components: 
\itemize{
 \item \code{lvl.comp} - the level component
 \item \code{pat.comp} - the pattern component
 \item \code{b} - the unstandardized regression weights
 \item \code{bstar} - the mean centered regression weights
 \item \code{xc} - the scalar constant times bstar
 \item \code{k} - the scale constant
 \item \code{Covpc} - the pattern effect
 \item \code{Ypred} - the predicted values
 \item \code{r2} - the proportion of variability attributed to the different components
 \item \code{F.table} - the associated F-statistic table
 \item \code{F.statistic} - the F-statistics
 \item \code{df} - the df used in the test
 \item \code{pvalue} - the p-values for the test}
}
\description{
Implements the criterion-related profile analysis described in Davison & Davenport (2002).
}
\details{
The \code{cpa} function requires two arguments: criterion and predictors. The function returns the criterion-related profile analysis described in Davison & Davenport (2002). Missing data are presently handled by specifying \code{na.action = "na.omit"}, which performs listwise deletion and \code{na.action = "na.fail"}, the default, which causes the function to fail. The following S3 generic functions are available: \code{summary()},\code{anova()}, \code{print()}, and \code{plot()}. These functions provide a summary of the analysis (namely, R2 and the level and pattern components); perform ANOVA of the R2 for the pattern, the level, and the overall model; provide output similar to \code{lm()}, and plots the pattern effect.
}
\examples{
\dontrun{
data(IPMMc)
mod <- cpa(R ~ A + H + S + B, data = IPMMc)
print(mod)
summary(mod)
plot(mod)
anova(mod)
}

}
\references{
Davison, M., & Davenport, E. (2002). Identifying criterion-related patterns of predictor scores using multiple regression. \emph{Psychological Methods, 7}(4), 468-484.
}
\seealso{
\code{\link{pcv}}
}
\keyword{method}

