% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_prompt.R
\name{add_prompt}
\alias{add_prompt}
\title{Add a tooltip for a specific element}
\usage{
add_prompt(
  ui_element,
  position = "bottom",
  message = NULL,
  type = NULL,
  size = NULL,
  permanent = FALSE,
  rounded = FALSE,
  animate = TRUE,
  bounce = FALSE,
  arrow = TRUE,
  shadow = TRUE
)
}
\arguments{
\item{ui_element}{Element on which a tooltip will be added.}

\item{position}{Position of the tooltip. Can be `bottom`, `bottom-left`, `bottom-right`, `left`, `right`, `top`, `top-left`, `top-right`. Default is `bottom`.}

\item{message}{Message to include in the tooltip. This argument is mandatory.}

\item{type}{Type of the tooltip. Can be `NULL` (default), `error`, `warning`, `info`, `success`.}

\item{size}{Size of the tooltip. Can be `NULL` (default), `small`, `medium`, `large`.}

\item{permanent}{Boolean indicating whether the tooltip should be visible permanently (or at the contrary only when hovering the element). Default is `FALSE`.}

\item{rounded}{Boolean indicating whether the corners of the tooltip should be rounded. Default is `FALSE`.}

\item{animate}{Boolean indicating whether there is a small animation when the tooltip appears. Default is `TRUE`.}

\item{bounce}{Boolean indicating whether there is a small boucing animation when the tooltip appears. Default is `FALSE`.}

\item{arrow}{Boolean indicating whether there is an arrow on the tooltip. Default is `TRUE`.}

\item{shadow}{Boolean indicating whether there should be a shadow effect. Default is `TRUE`.}
}
\value{
A tooltip when hovering the element concerned.
}
\description{
Add a tooltip for a specific element
}
\examples{
if (interactive()) {
library(shiny)

ui <- fluidPage(

  use_prompt(),

  add_prompt(
    tableOutput("table"),
    position = "bottom", type = "warning",
    message = "this is a table", permanent = FALSE,
    rounded = TRUE, animate = FALSE
  )

  # also works with magrittr's pipe
  # tableOutput("table") \%>\%
  #   add_prompt(
  #     position = "bottom", type = "warning",
  #     message = "this is a button", permanent = FALSE,
  #     rounded = TRUE, animate = FALSE
  #   )
)

server <- function(input, output, session) {

  output$table <- renderTable(head(mtcars))

}

shinyApp(ui, server)
}
}
