% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/328.Sum_Leng_GENERAL_SIM.R
\name{lengthSIM}
\alias{lengthSIM}
\title{Sum of length  calculated using simulation method}
\usage{
lengthSIM(n, LL, UL, s, a, b)
}
\arguments{
\item{n}{- Number of trials}

\item{LL}{- Lower limit}

\item{UL}{- Upper limit}

\item{s}{- Number of Hypothetical "p"}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}
}
\value{
A dataframe with
 \item{sumLen}{  The sum of the expected length}
 \item{explMean}{  The mean of the expected length}
 \item{explSD}{  The Standard Deviation of the expected length}
 \item{explMax}{  The max of the expected length}
 \item{explLL}{  The Lower limit of the expected length calculated using mean - SD}
 \item{explUL}{  The Upper limit of the expected length calculated using mean + SD}
}
\description{
Sum of length  calculated using simulation method
}
\details{
The calculation of the sum of length for \code{n} given lower limit \code{LL} and  upper limit \code{UL}
}
\examples{
LL=c(0,0.01,0.0734,0.18237,0.3344,0.5492)		#Lower and Upper Limits
UL=c(0.4507,0.6655,0.8176,0.9265,0.9899,1)
n= 5; s=5000; a=1; b=1;
lengthSIM(n,LL,UL,s,a,b)
}
\seealso{
Other Expected length: \code{\link{PlotexplGEN}},
  \code{\link{PlotexplSIM}}, \code{\link{PlotlengthGEN}},
  \code{\link{PlotlengthSIM}}, \code{\link{lengthGEN}}
}

