% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrmodel.R
\docType{class}
\name{lrmodel-class}
\alias{lrmodel-class}
\alias{predict,lrmodel-method}
\title{An S4 class to hold results from proportionality analysis.}
\usage{
\S4method{predict}{lrmodel}(object, newdata)
}
\arguments{
\item{object}{An \code{lrmodel} object.}

\item{newdata}{A non-negative count matrix.}
}
\description{
An S4 class to hold results from proportionality analysis.
}
\section{Methods (by generic)}{
\itemize{
\item \code{predict}: Log-ratio transform new data.
}}
\section{Slots}{

\describe{
\item{\code{MARGIN}}{Specifies the \code{MARGIN} that contains the sample
data. If \code{MARGIN = 1}, rows contain sample data.
If \code{MARGIN = 2}, columns contain sample data.}

\item{\code{replace}}{Stores the smallest non-zero value of the raw data,
used for replacing zeroes in the independent dataset.}

\item{\code{type}}{Specifies the type of log-ratio transformation used.}

\item{\code{rule}}{Specifies the denominators used during the
log-ratio transformation. For a clr-transformation, this contains
the geometric means of the samples. For an alr-transformation,
this contains the feature with fixed abundance.}

\item{\code{data}}{The raw data as transformed by the \code{rule}.}

\item{\code{raw}}{The raw data used to build the \code{rule}.}
}}
\examples{
library(propr)
data(mail)
model <- modelCLR(mail)
lr <- predict(model, mail)
}
\seealso{
\code{\link{modelCLR}}
}

