% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-params.R
\name{all}
\alias{all}
\title{A list of most parameters.}
\arguments{
\item{counts}{A data.frame or matrix. A "count matrix" with
subjects as rows and features as columns.}

\item{metric}{A character string. The proportionality metric
to calculate. Choose from "rho", "phi", or "phs".}

\item{ivar}{A numeric scalar. Specifies reference feature(s)
for additive log-ratio transformation. The argument will also
accept feature name(s) instead of the index position(s).
Set to "iqlr" to use inter-quartile log-ratio transformation.
Ignore to use centered log-ratio transformation.}

\item{select}{Optional. Use this to subset the final
proportionality matrix without altering the result.
Use this argument to rearrange feature order.}

\item{symmetrize}{A logical. If \code{TRUE}, forces symmetry
by reflecting the "lower left triangle".}

\item{alpha}{A double. See vignette for details. Leave missing
to skip Box-Cox transformation.}

\item{p}{An integer. The number of permutation cycles.}

\item{...}{Arguments passed to the wrapped method.}

\item{object, x, rho, propr, propd}{A \code{propr} or \code{propd} object.}

\item{subset}{Subsets via \code{object@counts[subset, ]}.
Use this argument to rearrange subject order.
For backwards compatibility.}

\item{i}{Operation used for the subset indexing. Select from
"==", "=", ">", ">=", "<", "<=", "!=", or "all".
For backwards compatibility.}

\item{j}{Provide a numeric value to which to compare the
proportionality measures in the \code{@matrix} slot.
For backwards compatibility.}

\item{tiny}{A logical scalar. Toggles whether to pass the indexed
result through \code{\link{simplify}}.
For backwards compatibility.}

\item{group}{A character vector. Group or sub-group memberships,
ordered according to the row names in \code{counts}.}

\item{weighted}{A boolean. Toggles whether to calculate
theta using \code{limma::voom} weights.}

\item{cutoff}{For \code{updateCutoffs}, a numeric vector.
this argument provides the FDR cutoffs to test.
For graph functions, a numeric scalar. This argument
indicates the maximum theta to include in the figure.
For graph functions, a large integer will instead
retrieve the top N pairs as ranked by theta.}

\item{what}{A character string. The theta type to set active.}

\item{moderated}{For \code{updateF}, a boolean. Toggles
whether to calculate a moderated F-statistic.}

\item{y}{Missing. Ignore. Leftover from the generic
method definition.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the courtesy prompt when working with big data.}

\item{plotly}{A logical scalar. Set to \code{TRUE} to produce
a dynamic plot using the \code{plotly} package.}

\item{k}{An integer. For \code{propr} methods, the number
of co-clusters (where all pairs receive a specified color
if and only if both members belong to same the cluster).
For \code{propd} methods, the maximum number of PALs to index
when calculating \code{\link{pals}} in the network.}

\item{col1, col2}{A character vector. Specifies which nodes
to color \code{red} or \code{blue}, respectively.}

\item{d3}{A boolean. Use \code{rgl} to plot 3D network.}

\item{reference}{A character string. A feature to use as the
denominator reference when comparing log-ratio abundances.}

\item{clean}{A boolean. Toggles whether to remove pairs
with "Bridged" or "Missing" PALs. Used by \code{geyser},
\code{bowtie}, and \code{gemini}.}

\item{plotSkip}{A boolean. Toggles whether to build
the network graph without plotting it.
Used by \code{\link{pals}}.}
}
\description{
A list of most parameters.
}
