\name{swath}

\alias{genSwathIonLib}
\alias{swath}

\title{swath library generator}

\description{

    This function generates an ion library for SWATH analysis.
    It reads R data object which contains a peaklist.
    The R data object can be generated using the scripts \code{exec/protViz_bibliospec2RData.py}.

}

\usage{

    genSwathIonLib(data, 
        mascotIonScoreCutOFF = 20, 
        proteinIDPattern = '',
        file,
        max.mZ.Da.error = 0.1, 
        ignoreMascotIonScore = TRUE, 
        topN = 10, 
        fragmentIonMzRange = c(200, 2000),
        fragmentIonRange = c(2, 100),
        fragmentIonTyp = c('b', 'y'),
        iRT=iRTpeptides)

}

\arguments{

  \item{data}{data set containing mZ and peptide sequence.}

  \item{mascotIonScoreCutOFF}{a value for filtering the specs.}

  \item{proteinIDPattern}{a filter for protein.}

  \item{file}{the output file name.}

  \item{max.mZ.Da.error}{the mZ error in Dalton.}

  \item{ignoreMascotIonScore}{boolean if mascot score is considered or not.}

  \item{topN}{returns the most \code{N} intense fragment ion only.}

  \item{fragmentIonMzRange}{mZ range filter of framgent ions.}

  \item{fragmentIonRange}{range filter of the number of identified fragment ions set in \code{fragmentIonTyp}.}

  \item{fragmentIonTyp}{is a filter. Set parameter to \code{'y'}, \code{'b'}, or \code{c('y', 'b')}. default is b and y. }

  \item{iRT}{optional table which contains iRT peptides. If an iRT table is provided (default) a \code{lm} is applied to normalize the rt in \code{data}. See also \code{?iRT}. A necessary condition is that \code{data} contains at least two iRT peptides.}

}

\details{

    The \code{parentIonMass} function reqires one argument \code{secuence}.
    The function expects an input as it can be generated by the python script \code{protViz/exec/protViz_bibliospec2RData.py}.

}

\author{

   Christian Panse, Christian Trachsel, and Jonas Grossmann 2012, 2013

}

\examples{
    data(AA)
    my.data<-list()
    my.data[[1]] <- list( 
        mZ=c(209.104, 245.126, 251.1478, 262.1427, 280.1395, 288.14244, 288.64, 302.13624, 
        302.1522, 344.67844, 345.1868, 358.67869, 359.191, 367.1805, 375.2397, 379.70739, 
        395.1672, 401.22119, 415.21764, 415.2413, 432.2574, 432.2906, 434.9155, 446.920753, 
        454.7938, 458.2398, 458.76219, 466.2048, 471.76349, 472.2635, 508.2509, 528.3204, 
        532.2273, 537.28544, 545.3398, 547.82244, 575.2645, 583.33849, 603.2592, 621.3354, 
        640.4081, 642.4034, 645.3303, 658.4226, 658.4447, 658.4781, 668.3981, 688.3384, 
        716.3516, 734.42, 771.5067, 791.4254, 813.4178, 829.436, 830.419, 908.5577),
        intensity=c(797.0, 150.3, 94.01, 95.0, 206.3, 268.3, 52.27, 745.0, 169.0, 372.0, 
        96.9, 817.0, 169.0, 149.7, 133.0, 132.0, 300.0, 237.3, 939.0, 169.0, 1780.0, 
        168.0, 280.0, 398.1, 248.1, 137.1, 159.0, 245.0, 375.0, 100.5, 188.0, 170.0, 
        138.1, 224.7, 2151.0, 188.3, 168.0, 1447.0, 1318.0, 138.1, 132.0, 75.0, 90.06, 
        1671.0, 614.0, 76.0, 75.0, 76.0, 359.1, 113.0, 761.0, 95.34, 38.0, 112.0, 76.0, 136.1),
        peptideSequence='AHAGEHLLLGLSR',
        charge=3,
        pepmass=458.59358,
        peptideModSeq='AHAGEHLLLGLSR',
        varModification=c(0,0,0,0,0,0,0,0,0,0,0,0,0),
        mascotScore=83.1,
        proteinInformation='',
        rtinseconds=61.55
        ); 

    genSwathIonLib(my.data)
}
