% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par-01-parSeqSim.R
\name{twoSeqSim}
\alias{twoSeqSim}
\title{Protein Sequence Alignment for Two Protein Sequences}
\usage{
twoSeqSim(
  seq1,
  seq2,
  type = "local",
  submat = "BLOSUM62",
  gap.opening = 10,
  gap.extension = 4
)
}
\arguments{
\item{seq1}{Character string, containing one protein sequence.}

\item{seq2}{Character string, containing another protein sequence.}

\item{type}{Type of alignment, default is \code{"local"},
could be \code{"global"} or \code{"local"},
where \code{"global"} represents Needleman-Wunsch global alignment;
\code{"local"} represents Smith-Waterman local alignment.}

\item{submat}{Substitution matrix, default is \code{"BLOSUM62"},
can be one of \code{"BLOSUM45"}, \code{"BLOSUM50"}, \code{"BLOSUM62"},
\code{"BLOSUM80"}, \code{"BLOSUM100"}, \code{"PAM30"}, \code{"PAM40"},
\code{"PAM70"}, \code{"PAM120"}, or \code{"PAM250"}.}

\item{gap.opening}{The cost required to open a gap of any length
in the alignment. Defaults to 10.}

\item{gap.extension}{The cost to extend the length of an existing
gap by 1. Defaults to 4.}
}
\value{
A \code{Biostrings} object containing the alignment scores
  and other alignment information.
}
\description{
Sequence alignment between two protein sequences.
}
\examples{
\dontrun{

# Be careful when testing this since it involves sequence alignment
# and might produce unpredictable results in some environments
library("Biostrings")
s1 <- readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]
s2 <- readFASTA(system.file("protseq/P10323.fasta", package = "protr"))[[1]]
seqalign <- twoSeqSim(s1, s2)
summary(seqalign)
score(seqalign)
}
}
\seealso{
See \code{\link{parSeqSim}} for paralleled pairwise
protein similarity calculation based on sequence alignment.
See \code{\link{twoGOSim}} for calculating the GO semantic
similarity between two groups of GO terms or two Entrez gene IDs.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
