% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_peptide_profiles.R
\name{plot_peptide_profiles}
\alias{plot_peptide_profiles}
\title{Peptide abundance profile plot}
\usage{
plot_peptide_profiles(
  data,
  sample,
  peptide,
  intensity_log2,
  grouping,
  targets,
  protein_abundance_plot = FALSE,
  interactive = FALSE,
  export = FALSE,
  export_name = "peptide_profile_plots"
)
}
\arguments{
\item{data}{Data frame containing at least the input variables.}

\item{sample}{Column in the data frame containing sample names.}

\item{peptide}{Column in the data frame containing peptide or precursor names.}

\item{intensity_log2}{Column in the data frame containing log2 transformed intensities.}

\item{grouping}{Column in the data frame containing groups by which the data should be split. This can be for example protein IDs.}

\item{targets}{Character vector specifying elements of the grouping column which should be plotted. This can also be
\code{"all"} if plots for all groups should be created. Depending on the number of elements in your grouping column this can be many
plots.}

\item{protein_abundance_plot}{Logical, if the input for this plot comes directly from \code{calculate_protein_abundance} this argument
can be set to \code{TRUE}. This displays all peptides in gray, while the protein abundance is displayed in green.}

\item{interactive}{A logical indicating whether the plot should be interactive (default is FALSE). If this is TRUE only one target can
be supplied to the function. Interactive plots cannot be exported either.}

\item{export}{A logical indicating if plots should be exported as PDF. The output directory will be the current working directory. The
name of the file can be chosen using the \code{export_name} argument.}

\item{export_name}{A character vector providing the name of the exported file if \code{export = TRUE}.}
}
\value{
A list of peptide profile plots.
}
\description{
Creates a plot of peptide abundances across samples. This is helpful to investigate effects of peptide and protein abundance changes
in different samples and conditions.
}
\examples{
\dontrun{
plot_peptide_abundance(
  data,
  sample = r_file_name,
  peptide = eg_precursor_id,
  intensity_log2 = log2_intensity,
  grouping = pg_protein_accessions,
  targets = c("P03421")
)
}
}
