% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.KDE}
\alias{plot.KDE}
\title{Plot a kernel density estimate}
\usage{
\method{plot}{KDE}(x, pch = "|", xlab = "age [Ma]", ylab = "", ...)
}
\arguments{
\item{x}{an object of class \code{KDE}}

\item{pch}{the symbol used to show the samples. May be a vector.
Set \code{pch = NA} to turn them off.}

\item{xlab}{the label of the x-axis}

\item{ylab}{the label of the y-axis}

\item{...}{optional parameters to be passed on to the graphics
object}
}
\description{
Plots an object of class \code{KDE}
}
\examples{
data(Namib)
samp <- Namib$DZ$x[['N1']]
dens <- KDE(samp,from=0,to=3000)
plot(dens)
}
\seealso{
KDE
}
