% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/partial.r
\name{partial}
\alias{partial}
\title{Partial apply a function, filling in some arguments.}
\usage{
partial(`_f`, ..., .env = parent.frame(), .lazy = TRUE)
}
\arguments{
\item{_f}{a function. For the output source to read well, this should be an
be a named function.  This argument has the weird (non-syntactic) name
\code{_f} so it doesn't accidentally capture any argument names begining
with f.}

\item{...}{named arguments to \code{f} that should be partially applied.}

\item{.env}{the environment of the created function. Defaults to
\code{\link{parent.frame}} and you should rarely need to modify this.}

\item{.lazy}{If \code{TRUE} arguments evaluated lazily, if \code{FALSE},
evaluated when \code{partial} is called.}
}
\description{
Partial function application allows you to modify a function by pre-filling
some of the arguments.  It is particularly useful in conjunction with
functionals and other function operators.
}
\section{Design choices}{


There are many ways to implement partial function application in R.
(see e.g. \code{dots} in \url{https://github.com/crowding/ptools} for another
approach.)  This implementation is based on creating functions that are as
similar as possible to the anonymous function that'd you'd create by hand,
if you weren't using \code{partial}.
}
\examples{
# Partial is designed to replace the use of anonymous functions for
# filling in function arguments. Instead of:
compact1 <- function(x) Filter(Negate(is.null), x)

# we can write:
compact2 <- partial(Filter, Negate(is.null))

# and the generated source code is very similar to what we made by hand
compact1
compact2

# Note that the evaluation occurs "lazily" so that arguments will be
# repeatedly evaluated
f <- partial(runif, n = rpois(1, 5))
f
f()
f()

# You can override this by saying .lazy = FALSE
f <- partial(runif, n = rpois(1, 5), .lazy = FALSE)
f
f()
f()

# This also means that partial works fine with functions that do
# non-standard evaluation
my_long_variable <- 1:10
plot2 <- partial(plot, my_long_variable)
plot2()
plot2(runif(10), type = "l")
}

