% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_beta.R
\docType{class}
\name{PriorBeta-class}
\alias{PriorBeta-class}
\alias{.prior_beta}
\title{\code{PriorBeta} Class}
\description{
A class for defining beta priors to be translated to Stan code.
Objects of class \code{PriorBeta} should not be created directly but by
the constructor \code{\link[=prior_beta]{prior_beta()}}.
}
\section{Slots}{

\describe{
\item{\code{stan_code}}{character. Stan implementation of the prior, with
placeholders for beta stan function parameters surrounded with
\verb{\{\{} and \verb{\}\}} to be replaced with \code{\link[glue:glue]{glue::glue()}}.}

\item{\code{n_param}}{integer. Number of prior parameters (2).}

\item{\code{constraint}}{character. Support of prior distribution,
\code{"<lower=0, upper=1>"}.}

\item{\code{alpha}}{numeric. Shape (>=0).}

\item{\code{beta}}{numeric. Shape (>=0).}
}}

\seealso{
Other prior classes: 
\code{\link{Prior-class}},
\code{\link{PriorBernoulli-class}},
\code{\link{PriorCauchy-class}},
\code{\link{PriorExponential-class}},
\code{\link{PriorGamma-class}},
\code{\link{PriorHalfCauchy-class}},
\code{\link{PriorHalfNormal-class}},
\code{\link{PriorNormal-class}},
\code{\link{PriorPoisson-class}},
\code{\link{UniformPrior-class}}
}
\concept{prior classes}
