% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppdpps.R
\name{calc_surv_psmpps}
\alias{calc_surv_psmpps}
\title{Derive PPS survival function under a PSM}
\usage{
calc_surv_psmpps(totime, fromtime = 0, ptdata, dpam, psmtype = "simple")
}
\arguments{
\item{totime}{Vector of times to which the survival function is calculated}

\item{fromtime}{Vector of times from which the survival function is calculated}

\item{ptdata}{Patient-level dataset}

\item{dpam}{List of fitted survival models for each endpoint}

\item{psmtype}{Either "simple" or "complex" PSM formulation}
}
\value{
Vector of PPS survival function values
}
\description{
Derive the post-progression survival (PPS) function under the simple or complex PSM formulation.
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_spl(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
  )
calc_surv_psmpps(totime=1:10,
  fromtime=rep(1,10),
  ptdata=bosonc,
  dpam=params,
  psmtype="simple")
}
}
