% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probgraphs.R
\name{prob_os_stm_cf}
\alias{prob_os_stm_cf}
\title{Calculate probability of being alive under the state transition clock forward model}
\usage{
prob_os_stm_cf(time, dpam, starting = c(1, 0, 0))
}
\arguments{
\item{time}{Time (numeric and vectorized) from baseline.}

\item{dpam}{List of survival regressions for model endpoints. This must include pre-progression death (PPD), time to progression (TTP) and post progression survival calculated under the clock forward model (PPS-CF).}

\item{starting}{Vector of membership probabilities (PF, PD, death) at time zero.}
}
\value{
Numeric value
}
\description{
Calculates membership probability of being alive at a given time (vectorized). This probability is from the state transition clock forward model, according to the given statistical distributions and parameters.
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_spl(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
)
prob_os_stm_cf(0:100, params)
}
}
