% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_confintv.R
\name{psrwe_ci}
\alias{psrwe_ci}
\title{Confidence/Credible Interval for PS-Integrated Estimation

Estimate the confidence/credible interval for the PS-integrated approach.}
\usage{
psrwe_ci(
  dta_psrst,
  method_ci = c("wald", "wilson"),
  conf_type = c("log_log", "plain"),
  conf_int = 0.95,
  ...
)
}
\arguments{
\item{dta_psrst}{a returned object with class \code{PSRWE_EST}}

\item{method_ci}{a method name for confidence interval (default Wald)}

\item{conf_type}{a type name of transformation for the confidence interal
of PSKM approach (default log_log)}

\item{conf_int}{a two-sided level of confidence/credible limits
(default 0.95)}

\item{...}{other options}
}
\value{
A list with class name \code{PSRWE_EST}.
}
\description{
Confidence/Credible Interval for PS-Integrated Estimation

Estimate the confidence/credible interval for the PS-integrated approach.
}
\details{
\code{method_ci = "wilson"} is for binary outcomes only.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
ps_rst <- psrwe_compl(ps_borrow, v_outcome = "Y_Con")
rst <- psrwe_ci(ps_rst)
rst

}
