% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_d.R
\name{simulate_d_sample}
\alias{simulate_d_sample}
\title{Simulate a sample of psychometric d value data with measurement error, direct range restriction, and/or indirect range restriction}
\usage{
simulate_d_sample(
  n_vec,
  rho_mat_list,
  mu_mat,
  sigma_mat = 1,
  rel_mat = 1,
  sr_vec = 1,
  k_items_vec = 1,
  wt_mat = NULL,
  sr_composites = NULL,
  group_names = NULL,
  var_names = NULL,
  composite_names = NULL,
  diffs_as_obs = FALSE
)
}
\arguments{
\item{n_vec}{Vector of sample sizes (or a vector of proportions, if parameters are to be estimated).}

\item{rho_mat_list}{List of true-score correlation matrices.}

\item{mu_mat}{Matrix of mean parameters, with groups on the rows and variables on the columns.}

\item{sigma_mat}{Matrix of standard-deviation parameters, with groups on the rows and variables on the columns.}

\item{rel_mat}{Matrix of reliability parameters, with groups on the rows and variables on the columns.}

\item{sr_vec}{Vector of selection ratios.}

\item{k_items_vec}{Number of test items comprising each of the variables to be simulated (all are single-item variables by default).}

\item{wt_mat}{Optional matrix of weights to use in forming a composite of the variables in \code{rho_mat.} Matrix should have as many rows (or vector elements) as there are variables in \code{rho_mat}.}

\item{sr_composites}{Optional vector selection ratios for composite variables. If not \code{NULL}, \code{sr_composites} must have as many elements as there are columns in \code{wt_mat}.}

\item{group_names}{Optional vector of group names.}

\item{var_names}{Optional vector of variable names.}

\item{composite_names}{Optional vector of names for composite variables.}

\item{diffs_as_obs}{Logical scalar that determines whether standard deviation parameters represent standard deviations of observed scores (\code{TRUE}) or of true scores (\code{FALSE}; default).}
}
\value{
A sample of simulated mean differences.
}
\description{
This function generates a simulated psychometric sample consisting of any number of groups and computes the \emph{d} values that result after introducing measurement error and/or range restriction.
}
\examples{
## Simulate statistics by providing integers as "n_vec":
simulate_d_sample(n_vec = c(200, 100), rho_mat_list = list(reshape_vec2mat(.5),
                                                           reshape_vec2mat(.4)),
                  mu_mat = rbind(c(1, .5), c(0, 0)), sigma_mat = rbind(c(1, 1), c(1, 1)),
                  rel_mat = rbind(c(.8, .7), c(.7, .7)), sr_vec = c(1, .5),
                  group_names = c("A", "B"))

## Simulate parameters by providing proportions as "n_vec":
simulate_d_sample(n_vec = c(2/3, 1/3), rho_mat_list = list(reshape_vec2mat(.5),
                                                           reshape_vec2mat(.4)),
                  mu_mat = rbind(c(1, .5), c(0, 0)), sigma_mat = rbind(c(1, 1), c(1, 1)),
                  rel_mat = rbind(c(.8, .7), c(.7, .7)), sr_vec = c(1, .5),
                  group_names = c("A", "B"))
}
