% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_n.R
\name{adjust_n_r}
\alias{adjust_n_r}
\title{Adjusted sample size for a non-Pearson correlation coefficient for use in a meta-analysis of Pearson correlations}
\usage{
adjust_n_r(r, var_e)
}
\arguments{
\item{r}{Vector of correlations.}

\item{var_e}{Vector of error variances.}
}
\value{
A vector of adjusted sample sizes.
}
\description{
This function is used to compute the adjusted sample size of a non-Pearson correlation (e.g., a tetrachoric correlation) based on the correlation and its estimated error variance.
This function allows users to adjust the sample size of a correlation corrected for sporadic artifacts (e.g., unequal splits of dichotomous variables, artificial dichotomization of continuous variables) prior to use in a meta-analysis.
}
\details{
The adjusted sample size is computed as:

\deqn{n_{adjusted}=\frac{(r^{2}-1)^{2}+var_{e}}{var_{e}}}{n_adjusted = ((r^2 - 1)^2 + var_e) / var_e}
}
\examples{
adjust_n_r(r = .3, var_e = .01)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
*Methods of meta-analysis: Correcting error and bias in research findings* (3rd ed.).
Sage. \doi{10.4135/9781483398105}. Equation 3.7.
}
