% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetMoistAirDensity}
\alias{GetMoistAirDensity}
\title{Return moist air density given humidity ratio, dry bulb temperature, and pressure.}
\usage{
GetMoistAirDensity(TDryBulb, HumRatio, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of moistAirDensity: Moist air density in lb ft-3 [IP] or kg m-3 [SI]
}
\description{
Return moist air density given humidity ratio, dry bulb temperature, and pressure.
}
\examples{
SetUnitSystem("IP")
GetMoistAirDensity(80:100, 0.02, 14.175)

SetUnitSystem("SI")
GetMoistAirDensity(20:30, 0.02, 95461)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 11
}
