% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptf_sparse.R
\name{ptf_sparse}
\alias{ptf_sparse}
\title{Fit a Probit RESCAL model (sparse representation).}
\usage{
ptf_sparse(df, n, k, r = 0, max_iter = 500, tol = 1e-08,
  tol_M = 1e-05, iter_M_max = 2, print_option = TRUE)
}
\arguments{
\item{df}{a four-column dataframe with columns (1) ent1 (2) ent2
(3) relation (4) true, which is an indicator of whether there is such a relation from ent1 to ent2}

\item{n}{number of entities}

\item{k}{number of relations}

\item{r}{decomposition rank}

\item{max_iter}{max number of iterations}

\item{tol}{tolerance of absolute change in ,elihood}

\item{tol_M}{tolerance of absolute change in the M step}

\item{iter_M_max}{max number of iterations for M step}

\item{print_option}{whether print log-likelihood for each iteration or not}
}
\value{
fitted parameters
}
\description{
Fit a Probit RESCAL model (sparse representation).
}
\examples{
n <- 20
k <- 10
r <- 3
A <- matrix(runif(n*r,0,1),n,r)
mean.k <- runif(k,-0.1,-0.01)
W <- lapply(1:k, function(i) matrix(rnorm(r*r,mean.k[i],1),r,r))
Z <- lapply(1:k, function(i) A\%*\%W[[i]]\%*\%t(A))
df <- data.frame(expand.grid(0:(n-1),0:(n-1),0:(k-1)))
df <-  df[sample(nrow(df),2000),]
colnames(df) <- c('ent1','ent2','relation')
awa <- function(row,A,W){
  inx1 <- row[1] + 1
  inx2 <- row[2] + 1
  rel <- row[3] + 1
  out <- A[inx1,] \%*\% W[[rel]] \%*\% A[inx2,]
}
z <- apply(df,1,function(row) awa(row,A,W))
df$true <- ifelse(z>0,1,0)
result2 <- ptf_sparse(df,n,k,r)

}
\references{
Ye Liu, 2021. Computational Methods for Complex Models with Latent Structure. 
PhD thesis with link at https://repository.lib.ncsu.edu/bitstream/handle/1840.20/37507/etd.pdf?sequence=1
}
