% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{loglik.pt.1re}
\alias{loglik.pt.1re}
\title{Loglikelihood of Poisson-Tweedie generalized linear mixed model with random intercept}
\usage{
loglik.pt.1re(beta, D, a, Sigma, y, X, Z, t, id, offset = NULL,
  GHk = 10, tol = 9.88131291682493e-324)
}
\arguments{
\item{beta}{Vector of regression coefficients}

\item{D}{Deviance}

\item{a}{Power parameter (must be < 1)}

\item{Sigma}{A matrix with the variance of the random intercept}

\item{y}{Response vector (discrete)}

\item{X}{Design matrix for the fixed effects}

\item{Z}{Design matrix for the random effects}

\item{t}{Time variable}

\item{id}{Id indicator (it should be numeric)}

\item{offset}{Offset term to be added to the linear predictor}

\item{GHk}{Number of quadrature points (default is 10)}

\item{tol}{Tolerance value for the evaluation of the probability mass function of the Poisson-Tweedie distribution}
}
\value{
The loglikelihood value obtained using a Gauss-Hermite quadrature 
approximation with \code{GHk} quadrature points.
}
\description{
Evaluates the loglikelihood of a Poisson-Tweedie generalized linear mixed model 
with random intercept, using the adaptive Gauss-Hermite quadrature rule.
}
\seealso{
\code{\link{ptmixed}} and the examples therein
}
\author{
Mirko Signorelli
}
