% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stops.R
\name{stops_on_route}
\alias{stops_on_route}
\title{Stops on a given route and route type}
\usage{
stops_on_route(
  route_id,
  route_type,
  direction_id = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{route_id}{Integer. These can be listed and described with the \code{routes}
function.}

\item{route_type}{A route type which can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the \code{route_types}
function to extract a vector of all route types.}

\item{direction_id}{Optionally filter by a direction ID. These can be
obtained with the \code{directions_on_route} function.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item{\code{stop_id}}
\item{\code{stop_name}}
\item{\code{stop_suburb}}
\item{\code{route_type}}
\item{\code{stop_sequence}}
\item{\code{stop_latitude}}
\item{\code{stop_longitude}}
\item{\code{disruption_ids}}
}
}
\description{
Stops on a given route and route type
}
\examples{
\dontrun{
stops_on_route(6, route_type = "Train")
stops_on_route(6, route_type = 0)
}

}
