% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities-snorm.R
\name{snorm}
\alias{snorm}
\alias{dsnorm}
\alias{rsnorm}
\alias{esnorm}
\title{Selected Normal Effect Size Distribution}
\usage{
dsnorm(x, theta0, tau, sigma, alpha = c(0, 0.025, 0.05, 1), eta, log = FALSE)

rsnorm(n, theta0, tau, sigma, alpha = c(0, 0.025, 0.05, 1), eta)

esnorm(theta0, tau, sigma, alpha, eta)
}
\arguments{
\item{x}{vector of quantiles.}

\item{theta0}{vector of means.}

\item{tau}{vector of heterogeneity parameters.}

\item{sigma}{vector of study standard deviations.}

\item{alpha}{vector of thresholds for publication bias.}

\item{eta}{vector of publication probabilities, normalized to sum to 1.}

\item{log}{logical; If \code{TRUE}, probabilities are given as
\code{log(p)}.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dsnorm} gives the density, \code{psnorm} gives the distribution
function, and \code{rsnorm} generates random deviates.
}
\description{
Density, random variate generation, and expectation calculation for the
effect size distribution of the one-sided normal publication bias model.
}
\details{
The effect size distribution for the publication selection model is not
normal, but has itself been selected for. These functions assume a
normal underlying effect size distribution and one-sided selection on the
effects.
}
\examples{
rsnorm(100, theta0 = 0, tau = 0.1, sigma = 0.1, eta = c(1, 0.5, 0.1))
}
\references{
Hedges, Larry V. "Modeling publication selection effects
in meta-analysis." Statistical Science (1992): 246-255.

Moss, Jonas and De Bin, Riccardo. "Modelling publication
bias and p-hacking" (2019) arXiv:1911.12445
}
