% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggwave.R
\name{ggwave}
\alias{ggwave}
\title{Plot the Partitioned Functional Wave by PULS}
\usage{
ggwave(
  toclust.fd,
  intervals,
  puls.obj,
  xlab = NULL,
  ylab = NULL,
  lwd = 0.5,
  alpha = 0.4,
  lwd.med = 1
)
}
\arguments{
\item{toclust.fd}{A functional data object (i.e., having class \code{fd}) created
from \code{fda} package. See \code{\link[fda:fd]{fda::fd()}}.}

\item{intervals}{A data set (or matrix) with rows are intervals and columns
are the beginning and ending indexes of of the interval.}

\item{puls.obj}{A \code{PULS} object as a result of \code{\link[=PULS]{PULS()}}.}

\item{xlab}{Labels for x-axis. If not provided, the labels stored in \code{fd}
object will be used.}

\item{ylab}{Labels for y-axis.  If not provided, the labels stored in \code{fd}
object will be used.}

\item{lwd}{Linewidth of normal waves.}

\item{alpha}{Transparency of normal waves.}

\item{lwd.med}{Linewidth of medoid waves.}
}
\value{
A ggplot2 object.
}
\description{
After partitioning using PULS, this function can plot the functional waves
and color different clusters as well as their medoids.
}
\examples{
\donttest{
library(fda)

# Build a simple fd object from already smoothed smoothed_arctic
data(smoothed_arctic)
NBASIS <- 300
NORDER <- 4
y <- t(as.matrix(smoothed_arctic[, -1]))
splinebasis <- create.bspline.basis(rangeval = c(1, 365),
                                    nbasis = NBASIS,
                                    norder = NORDER)
fdParobj <- fdPar(fdobj = splinebasis,
                  Lfdobj = 2,
                  # No need for any more smoothing
                  lambda = .000001)
yfd <- smooth.basis(argvals = 1:365, y = y, fdParobj = fdParobj)

Jan <- c(1, 31); Feb <- c(31, 59); Mar <- c(59, 90)
Apr <- c(90, 120); May <- c(120, 151); Jun <- c(151, 181)
Jul <- c(181, 212); Aug <- c(212, 243); Sep <- c(243, 273)
Oct <- c(273, 304); Nov <- c(304, 334); Dec <- c(334, 365)

intervals <-
  rbind(Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec)

PULS4_pam <- PULS(toclust.fd = yfd$fd, intervals = intervals,
                  nclusters = 4, method = "pam")
ggwave(toclust.fd = yfd$fd, intervals = intervals, puls = PULS4_pam)
}
}
