% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pureseqtm_files.R
\name{create_pureseqtm_files}
\alias{create_pureseqtm_files}
\title{Create the five PureseqTM output files, by running PureseqTM.}
\usage{
create_pureseqtm_files(
  fasta_filename,
  folder_name = get_default_pureseqtm_folder(),
  temp_folder_name = tempfile(pattern = "pureseqt_")
)
}
\arguments{
\item{fasta_filename}{path to a FASTA file}

\item{folder_name}{superfolder of PureseqTM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_pureseqtm_folder}}

\item{temp_folder_name}{path of a temporary folder.
The folder does not need to exist.
Files that are out in this folder are not automatically
deleted, which is not a problem, as the default
path given by \link{tempdir} is automatically cleaned
by the operating system}
}
\value{
full path to the files created
}
\description{
Create the five PureseqTM output files, by running PureseqTM.
}
\examples{
if (is_pureseqtm_installed()) {
  fasta_filename <- get_example_filename("1bhaA.fasta")
  create_pureseqtm_files(fasta_filename)
}
}
\author{
Richèl J.C. Bilderbeek
}
