% Generated by roxygen2 (4.0.2): do not edit by hand
\name{BridgeT}
\alias{BridgeT}
\title{Bridge transformation}
\usage{
BridgeT(x, normalize = TRUE)
}
\arguments{
\item{x}{x a numeric vector of data values.}

\item{normalize}{\code{logical}, indicating whether the vector should be normalized.}
}
\value{
A numeric vector.
}
\description{
Transforms data by Bridge transformation.
}
\details{
Let \code{n} denotes the length ox \code{x}.
For  each \eqn{m \in [1,n]} bridge transformations \code{BridgeT}
is defined as

\deqn{
  BridgeT(m, x) = \left\{ \sum_{i=1}^m x_i - \frac{m}{n} \sum_{i=1}^n x_i  \right\} .
}{
  BridgeT(m, x) = ( \sum^m x_i - m/n \sum^n x_i ).
}

Meanwhile, the transformation with normalization is

\deqn{
  BridgeT(m, x) = \frac{1}{\sqrt{n var(x)}} \left\{ \sum_{i=1}^m x_i - \frac{m}{n} \sum_{i=1}^n x_i  \right\} .
}{
  BridgeT(m, x) = ( \sum^m x_i - m/n \sum^n x_i  ) / (n var(x))^0.5.
}
}
\examples{
x <- rnorm(1000)
Bx <- BridgeT(x, FALSE)

op <- par(mfrow=c(2,1),mar=c(4,4,2,1))
plot(cumsum(x), type="l")
plot(Bx, type="l")
par(op)
}
\seealso{
\code{\link{PvarBreakTest}},  \code{\link{rbridge}}
}

