% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_query.R
\name{pxweb_validate_query_with_metadata}
\alias{pxweb_validate_query_with_metadata}
\title{Validate a \code{pxweb_query} with a \code{pxweb_metadata} object}
\usage{
pxweb_validate_query_with_metadata(pxq, pxmd)
}
\arguments{
\item{pxq}{a \code{pxweb_query} object.}

\item{pxmd}{a \code{pxweb_metadata} object.}
}
\description{
Validate a \code{pxweb_query} with a \code{pxweb_metadata} object
}
\details{
Validate a query with a metadata object to asses that the query can be used to 
query the table.
}
\examples{
url <- "http://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101/BE0101A/BefolkningNy"
json_query <- file.path(system.file(package = "pxweb"), 
                        "extdata", "examples", "json_query_example.json")
pxq <- pxweb_query(json_query)
pxweb_validate_query_with_metadata(pxq, pxweb_get(url))

}
