% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_pzfx.R
\name{write_pzfx}
\alias{write_pzfx}
\title{Write one table or multiple tables to a 'GraphPad Prism' '.pzfx' file}
\usage{
write_pzfx(x, path, row_names = TRUE, x_col = NA)
}
\arguments{
\item{x}{Input table or named list of tables that will be 'Data Tables' in the '.pzfx' file}

\item{path}{Path to the output '.pzfx' file.}

\item{row_names}{Logical. If row names of the input table should be preserved and become row
titles in the output '.pzfx' file. If the length is greater than 1, it must match the length of
list of input tables. Default: TRUE.}

\item{x_col}{1-based column index or name of the column to be used as the 'X' column. If the
length is greater than 1, it must match the length of list of input tables. All other columns
in the input tables will be treated as "Y" columns in the output '.pzfx' file. Default: NA}
}
\value{
write_pzfx returns the input x invisibly.
}
\description{
Write one table or multiple tables to a 'GraphPad Prism' '.pzfx' file. A table can be a 'matrix',
  a 'data.frame', or a 'tibble'. All elements of the table should be numeric.
}
\examples{
pzfx_file <- system.file("extdata/exponential_decay.pzfx", package = "pzfx", mustWork = TRUE)
df <- read_pzfx(pzfx_file, table = 1, strike_action = "exclude")
write_pzfx(df, path = tempfile(fileext = ".pzfx"), row_names = TRUE)
}
