#' @title Time spent watching television - 2017
#' @description This is a data set detailing TV usage on days surveyed as determined by the 2017 American Time Use Survey. The data set includes demographic information, as well as details regarding employment and family makeup, where applicable. Information on days surveyed, as well as whether the day is a holiday, is also included.
#' @details
#' For more information regarding the key visit
#' \href{https://www.bls.gov/tus/atusintcodebk17.pdf}{https://www.bls.gov/tus/atusintcodebk17.pdf}.
#' This data is retrieved from the American Time Use Survey, made available through the
#' Bureau of Labor Statistics \href{https://www.bls.gov/tus/datafiles_2017.htm}{https://www.bls.gov/tus/datafiles_2017.htm}.
#' @usage tv
#' @docType data
#' @keywords datasets
#' @name tv
#' @format A data frame with 10,223 rows and 21 variables. The variables are
#' as follows:
#' \describe{
#' \item{id}{ ID of respondent}
#' \item{weight}{ATUS final weight}
#' \item{youngest_child}{Age of the youngest child in the household that is less than 18 years old (if applicable). Range: 1-17; if no child in household: NA}
#' \item{age}{Age of respondent}
#' \item{sex}{Sex of respondent}
#' \item{job}{Status of employment of the respondent. Direct transcription from original codebook:
#'  1 = Employed, at work,
#'  2 = Employed, absent,
#'  3 = Unemployed, on layoff,
#'  4 = Unemployed, looking,
#'  5 = Not in the labor force.
#' }
#' \item{m_job}{The response to question, “in the last seven days did you have more than one job?” Returns NA if no job.}
#' \item{f_job}{Does the respondent have a full time job or a part time job? (NA if no job)}
#' \item{educ}{Are you enrolled in high school, college, or university? (NA if not currently enrolled)}
#' \item{educ2}{If yes to educ, are you enrolled in high school or upper schooling? (NA if not currently enrolled)}
#' \item{partner}{Presence of the respondent's spouse or unmarried partner in the household with
#'  1 = Spouse present
#'  2 = Unmarried partner present
#'  3 = No spouse/unmarried partner present
#' }
#' \item{pr_job}{Answer to the question, “does your partner have a job?” (NA if not applicable)}
#' \item{salary}{Weekly earnings at the respondent’s main job, two decimals implied}
#' \item{children}{Number of children under 18 in the household}
#' \item{pr_job_f}{Part time/full time job status of partner, if applicable (NA if partner unemployed or no partner)}
#' \item{job_hours}{Total hours usually worked per week (-4: Hours vary)}
#' \item{day}{Day of the week about which the respondent was interviewed (Monday thorugh Friday)}
#' \item{holiday}{Notes if the respondent was interviewed on a holiday}
#' \item{elder_care}{Total time spent providing elder care that day by the respondent, in minutes}
#' \item{child_time}{Total time spent during diary day providing secondary childcare for household children younger than 13, in minutes}
#' \item{tv}{ Minutes spent watching TV}
#' }
#' @examples
#' summary(tv)
#'
#' hist(tv$tv, col="skyblue")
NULL
