% Generated by roxygen2 (4.0.0): do not edit by hand
\name{multigsub}
\alias{mgsub}
\alias{multigsub}
\alias{sub_holder}
\title{Multiple gsub}
\usage{
multigsub(pattern, replacement = NULL, text.var, leadspace = FALSE,
  trailspace = FALSE, fixed = TRUE, trim = TRUE, order.pattern = fixed,
  ...)

mgsub(pattern, replacement = NULL, text.var, leadspace = FALSE,
  trailspace = FALSE, fixed = TRUE, trim = TRUE, order.pattern = fixed,
  ...)

sub_holder(pattern, text.var, ...)
}
\arguments{
\item{pattern}{Character string to be matched in the given character vector.}

\item{replacement}{Character string equal in length to pattern or of length
one which are  a replacement for matched pattern.}

\item{text.var}{The text variable.}

\item{leadspace}{logical.  If \code{TRUE} inserts a leading space in the
replacements.}

\item{trailspace}{logical.  If \code{TRUE} inserts a trailing space in the
replacements.}

\item{fixed}{logical. If \code{TRUE}, pattern is a string to be matched as is.
Overrides all conflicting arguments.}

\item{trim}{logical.  If \code{TRUE} leading and trailing white spaces are
removed.}

\item{order.pattern}{logical.  If \code{TRUE} and \code{fixed = TRUE}, the
\code{pattern} string is sorted by number of characters to prevent substrings
replacing meta strings (e.g., \code{pattern = c("the", "then")} resorts to
search for "then" first).}

\item{\dots}{Additional arguments passed to \code{\link[base]{gsub}}.}
}
\value{
\code{multigsub} - Returns a vector with the pattern replaced.

\code{sub_holder} - Returns a list with the following:
\item{output}{keyed place holder character vector}
\item{unhold}{A function used to revert back to the original values}
}
\description{
\code{multigsub} - A wrapper for \code{\link[base]{gsub}} that takes a vector
of search terms and a vector or single value of replacements.

\code{sub_holder} - This function holds the place for particular character
values, allowing the user to manipulate the vector and then revert the place
holders back to the original values.
}
\note{
The \code{unhold} function for \code{sub_holder} will only work on keys
that have not been disturbed by subsequen alterations.  The key follows the
pattern of `qdapplaceholder` followed by lower case letter keys followed by
`qdap`.
}
\examples{
\dontrun{
multigsub(c("it's", "I'm"), c("it is", "I am"), DATA$state)
mgsub(c("it's", "I'm"), c("it is", "I am"), DATA$state)
mgsub("[[:punct:]]", "PUNC", DATA$state, fixed = FALSE)

## `sub_holder` Function
(fake_dat <- paste(emoticon[1:11,2], DATA$state))
(m <- sub_holder(emoticon[,2], fake_dat))
m$unhold(strip(m$output))
# With Stemming
m$unhold(stemmer(strip(m$output), capitalize = FALSE))
}
}
\seealso{
\code{\link[base]{gsub}}
}

