% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{qser2sar}
\alias{qser2sar}
\title{Spline Autoregression (SAR) Model of Quantile Series}
\usage{
qser2sar(
  y.qser,
  tau,
  d = 1,
  p = NULL,
  order.max = NULL,
  spar = NULL,
  method = c("AIC", "BIC", "GCV"),
  weighted = FALSE
)
}
\arguments{
\item{y.qser}{matrix or array of pre-calculated QSER, e.g., using \code{qser()}}

\item{tau}{sequence of quantile levels where \code{y.qser} is calculated}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{p}{order of SAR model (default = \code{NULL}: automatically selected by AIC)}

\item{order.max}{maximum order for AIC if \code{p = NULL} (default = \code{NULL}: determined by \code{stats::ar()})}

\item{spar}{penalty parameter alla \code{smooth.spline} (default = \code{NULL}: automatically selected)}

\item{method}{criterion for penalty parameter selection:  \code{"AIC"} (default), \code{"BIC"}, or \code{"GCV"}}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}
}
\value{
a list with the following elements:
  \item{A}{matrix or array of SAR coefficients}
  \item{V}{vector or matrix of SAR residual covariance}
  \item{p}{order of SAR model}
  \item{spar}{penalty parameter}
  \item{tau}{sequence of quantile levels}
  \item{n}{length of time series}
  \item{d}{subsampling rate of quantile levels}
  \item{weighted}{option for weighted penalty function}
  \item{fit}{object containing details of SAR fit}
}
\description{
This function fits spline autoregression (SAR) model to quantile series (QSER).
}
