% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_sum_pairwise.R
\name{dist_sum_pairwise}
\alias{dist_sum_pairwise}
\title{Distance between pairs of fatty acid signatures}
\usage{
dist_sum_pairwise(sig_data, dist_meas = 1, gamma = 1)
}
\arguments{
\item{sig_data}{A numeric matrix of fatty acid signatures in column-major
format.}

\item{dist_meas}{An integer indicator of the distance measure to compute.
Default value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}
}
\value{
The summed distance between all possible pairs of signatures.
}
\description{
The utility function \code{dist_sum_pairwise} computes the total distance
between all possible pairs of fatty acid signatures.
}
\section{Details}{

\code{dist_sum_pairwise} is an internal utility function.  The signature
data in \code{sig_data} are presumed to be ready for analysis, which is best
accomplished by a call to the function \code{prep_sig}.  Consequently, to
increase execution speed during simulations, no numeric error checking of the
signatures is performed.  Please refer to documentation for the function
\code{\link{prep_sig}} for information regarding signature preparation.

Please refer to documentation for the function
\code{\link{dist_between_2_sigs}} for additional information regarding the
arguments \code{dist_meas} and \code{gamma}.

Utility functions called by \code{dist_sigs_2_mean}:
  \itemize{
  \item \code{\link{dist_between_2_sigs}}
  }
}

