% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_utility.R
\name{vc_comb}
\alias{vc_comb}
\title{Calculate covariance matrix between one random variable and a linear combination of
random variables}
\usage{
vc_comb(aname = "(Intercept)", expnms, covmat, grad = NULL)
}
\arguments{
\item{aname}{character scalar with the name of the first column of interest (e.g. variable
A in the examples given in the details section)}

\item{expnms}{a character vector with the names of the columns to be
of interest in the covariance matrix for a which a standard error will be
calculated (e.g. same as expnms in qgcomp fit)}

\item{covmat}{covariance matrix for parameters, e.g. from a model or
bootstrap procedure}

\item{grad}{not yet used}
}
\value{
A covariance matrix
}
\description{
This function uses the Delta method to calculate a covariance matrix of linear
functions of variables and is used internally in qgcomp. Generally, users will not need to
call this function directly.
}
\details{
This function takes inputs of a name of random variable (character), as
set of exposure names (character vector) and a covariance matrix (with colnames/rownames
that contain the indepdendent variable and the full set
of exposure names). See \code{\link[qgcomp]{se_comb}} for details on variances of sums
of random variables. Briefly, for variables A, B and C with covariance matrix Cov(A,B,C),
we can calculate the covariance Cov(A,B+C) with the formula Cov(A,B) + Cov(A,C), and
Cov(A,B+C+D) = Cov(A,B) + Cov(A,C) + Cov(A,D), and so on.
}
\examples{
vcov = rbind(c(0.010051348, -0.0039332248, -0.0036965571),
             c(-0.003933225,  0.0051807876,  0.0007706792),
             c(-0.003696557,  0.0007706792,  0.0050996587))
colnames(vcov) <- rownames(vcov) <- c("(Intercept)", "x1", "x2")
expnms <- rownames(vcov)[2:3]
aname = rownames(vcov)[1]
vc_comb(aname, expnms, vcov) # returns the given covariance matrix
}
