% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_simulation.R
\name{gsim}
\alias{gsim}
\title{Genomic simulation}
\usage{
gsim(Glist = NULL, chr = 1, nt = 1, W = NULL, n = 1000, m = 1000)
}
\arguments{
\item{Glist}{list of information about genotype matrix}

\item{chr}{is the chromosome(s) being used in the simulation}

\item{nt}{number of traits}

\item{W}{matrix of centered and scaled genotypes}

\item{n}{number of individuals}

\item{m}{number of markers}
}
\description{
The gsim function is used for simulating genotype and phenotype data based Glist.
It is currently under active development.
}
\examples{

 ## Plink bed/bim/fam files
 bedfiles <- system.file("extdata", paste0("sample_chr",1:2,".bed"), package = "qgg")
 bimfiles <- system.file("extdata", paste0("sample_chr",1:2,".bim"), package = "qgg")
 famfiles <- system.file("extdata", paste0("sample_chr",1:2,".fam"), package = "qgg")
 
 # Summarize bed/bim/fam files
 Glist <- gprep(study="Example", bedfiles=bedfiles, bimfiles=bimfiles, famfiles=famfiles)
 
 # Simulate phenotype
 sim <- gsim(Glist=Glist, chr=1, nt=1)
 head(sim$y)
 head(sim$e)
 head(sim$causal)
 

}
\author{
Peter Soerensen
}
