% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qiimer.R
\docType{data}
\name{relmbeta}
\alias{relmbeta}
\title{Sample dataset from murine gut microbiome}
\format{A data frame with 20 rows and 3 columns.}
\source{
Hildebrandt et al. High-fat diet determines the composition of the 
  murine gut microbiome independently of obesity. \emph{Gastroenterology} 
  \strong{137}, 1716 (2009).
}
\description{
The \code{relmbeta} dataset is taken from a mouse study where wild-type 
and RELMbeta knockout mice were fed either a normal or high-fat diet.  
The diet was observed to have a pronounced effect on the gut microbiome 
composition.  The genotype also had an effect, but less so.
}
\details{
The bacterial 16S rDNA gene was sequenced using 454 FLX technology, 
producing about 26k reads.  The reads were processed via the standard QIIME
workflow, \code{pick_de_novo_otus.py}, which clustered the reads into 776 
operational taxonomic units (OTUs).  QIIME version 1.7.0 was used for the 
analysis.

The OTU table was filtered to remove OTUs appearing in only one sample.
Following this, a single rarefaction was performed at a level of 500 reads
per sample.  The unweighted UniFrac distance was then computed for each pair 
of samples.

The \code{relmbeta} data frame lists the sample IDs, genotypes, and dietary 
assignments for the mice.
}
\keyword{datasets}

