% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krige.R
\name{multiDimLHS}
\alias{multiDimLHS}
\title{Multidimensional Latin Hypercube Sampling (LHS) generation}
\usage{
multiDimLHS(N, lb, ub, method = c("randomLHS", "maximinLHS",
  "augmentLHS"), X = NULL, type = c("list", "matrix"))
}
\arguments{
\item{N}{number of points to randomly select or augment an existing sample set}

\item{lb}{lower bounds defining the (hyper)box of the parameter search space}

\item{ub}{upper bounds defining the (hyper)box of the parameter search space}

\item{method}{type of sampling, `\code{randomLHS}`, `\code{maximinLHS}` or `\code{augmentLHS}`}

\item{X}{optional, matrix of existing sample points, \code{NULL} (default), for augmentation only}

\item{type}{either "\code{list}" or "\code{matrix}" as return type}
}
\value{
Either return a list or matrix of sampled vectors or newly generated points if an existing sample set
 was to be augmented.
}
\description{
The function generates or augments a multidimensional design in a hyperbox.
}
\examples{
data(normal)
# generate a design
X <- multiDimLHS(N=5,qsd$lower,qsd$upper,type="matrix")

# augment design X 
rbind(X,multiDimLHS(N=1,qsd$lower,qsd$upper,X=X,
				method="augmentLHS",type="matrix"))


}
\seealso{
\code{\link[lhs]{randomLHS}}, \code{\link[lhs]{maximinLHS}}, \code{\link[lhs]{augmentLHS}}
}
\author{
M. Baaske
}
