% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SAI.R
\name{plot.SAI}
\alias{plot.SAI}
\title{Graphical representation of a SAI object.}
\usage{
\method{plot}{SAI}(
  x,
  ...,
  min.age = 1,
  max.age = 100,
  decimal.digits = 1,
  color.main = "black",
  color.lm = "blue",
  color.hline = "red",
  size.labels.y = 8,
  axis.age.ticks,
  limits.joint,
  breaks.joint,
  limits.ageing,
  breaks.ageing,
  limits.seasonal,
  breaks.seasonal,
  name.labels.ageing = c("Q1", "Q2", "Q3", "Q4"),
  name.labels.season = c("Winter", "Spring", "Summer", "Autumn"),
  title.season = "Seasonal effects",
  title.ageing = "Ageing effects",
  x.title = "Age",
  show.plot = TRUE
)
}
\arguments{
\item{x}{An object output of the \code{\link{compute_SAI}} or \code{\link{SAI_shortcut_1}} functions.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{min.age}{A positive integer informing about the initial minimal age of the range of ages to be represented.
This minimum age can be increased depending on the ages available in the SAI estimates.
Default, 1.}

\item{max.age}{A positive integer informing about the initial maximum age of the range of ages to be represented.
This maximum age can be decreased depending on the ages available in the SAI estimates.
Default, 100.}

\item{decimal.digits}{Integer indicating the number of decimal places to be shown. Default, 1.}

\item{color.main}{Color of the line corresponding to the estimated, normalized SAI. Default, "black".}

\item{color.lm}{Color of the lm line. Default, "blue".}

\item{color.hline}{Color of the hline (reference) line. Default, "red".}

\item{size.labels.y}{Number informing the size of the labels of SAI axis. Default, 8.}

\item{axis.age.ticks}{Optional vector with the values to be presented in the age axis.}

\item{limits.joint}{Optional vector of length 2 with the limits for the SAI axis of the main plot.}

\item{breaks.joint}{Optional vector with the values to be presented in the SAI axis of the main plot.}

\item{limits.ageing}{Optional vector of length 2 with the limits for the SAI axis of the marginal ageing SAI plot.}

\item{breaks.ageing}{Optional vector with the values to be presented in the SAI axis of the marginal ageing SAI plot.}

\item{limits.seasonal}{Optional vector of length 2 with the limits for the SAI axis of the marginal seasonal (calendar) SAI plot.}

\item{breaks.seasonal}{Optional vector with the values to be presented in the SAI axis of the marginal seasonal (calendar) SAI plot.}

\item{name.labels.ageing}{Names to be used for the (y) ageing axis. Default, c("Q1", "Q2", "Q3", "Q4").}

\item{name.labels.season}{Names to be used for the (x) season (calendar) axis. Default, c("Winter", "Spring", "Summer", "Autumn").}

\item{title.season}{Name to be used for identifying the seasonal marginal panels. Default, "Seasonal effects".}

\item{title.ageing}{Name to be used for identifying the ageing marginal panels. Default, "Ageing effects".}

\item{x.title}{Name to be used for the x axis. Default, "Age".}

\item{show.plot}{A TRUE/FALSE value indicating whether the plot should be displayed as a side-effect. By default, TRUE.}
}
\value{
Invisibly returns the grob description of the plot, which is a list with components that contain the plot itself, the data, information about the scales, panels, etc.
}
\description{
Plot method for a SAI object. This is a plot method for objects obtained using the \code{\link{compute_SAI}} function
or the \code{\link{SAI_shortcut_1}} function.
}
\note{
ggplot2 and gridExtra packages are needed to be installed for this function to work.
}
\examples{
\donttest{
# This can take a while
 t.stock <- time_exposed_stock(pop_2006$date.birth, 2006, "forward")
 t.stock <- t.stock[t.stock$age <= 100, ]
 temp <- quarterly_variables(death_2006$date.birth, death_2006$date.death)
 e.death <- count_events_quarter(temp)
 e.death <- e.death[e.death$age <= 100, ]
 t.birth <- time_exposed_newborns(birth_2006$date.birth)
 out <- crude_mx(t.stock, e.death, time.birth = t.birth)
 SAI.example <- compute_SAI(out, out)
 p <- plot(SAI.example, show.plot = FALSE)
}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
