% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq2uu.R
\name{qq2uu}
\alias{qq2uu}
\title{qq2uu}
\usage{
qq2uu(qq)
}
\arguments{
\item{qq}{(character) a vector of QQIDs}
}
\value{
(character)  a vector of UUIDs
}
\description{
\code{qq2uu} converts a vector of QQIDs to UUIDs.
}
\section{QQIDs}{
 QQIDs are specially formatted 128-bit numbers (hexlets), just
  like UUIDs. See \code{\link[=xlt2qq]{xlt2qq()}} for the the motivation of
  mapping UUIDs to QQIDs and details on how QQIDs are structured.
  \code{qq2uu} reverses the mapping exactly to recover the original UUID.
}

\section{Process}{
 To convert a QQID to a UUID, the two "Q-words" that head
  the QQID are mapped to their index in the 0:1023 Q-word vector (cf.
  \code{\link[=qMap]{qMap()}}), and the indices are converted to two ten bit
  numbers. These twenty bits are expressed as a five-digit hexadecimal number
  which replaces the two Q-words to recover the UUID. For details on UUID
  format see \code{\link[=is.xlt]{is.xlt()}}. The remaining 18 Base64 encoded
  characters are converted to their corresponding 27 hex digits via an
  intermediate mapping to bit-patterns.
}

\section{Endianness}{
 The \code{qqid} package uses its own functions to
  convert to and from bits, and is not affected by big-endian vs.
  little-endian processor architecture or variant byte order. All numbers are
  interpreted to have their lowest order digits on the right.
}

\examples{
# Convert three example QQIDs and one NA to the corresponding UUIDs
qq2uu( c(QQIDexample(c(1, 3, 5)), NA) )

# forward and back again
myID <- "bird.carp.7TsBWtwqtKAeCTNk8f"
myID == xlt2qq(qq2uu(myID))             # TRUE

# Confirm that example QQID No. 3 is formatted correctly as a UUID
qq2uu( QQIDexample(3) ) == xltIDexample("UUID")  # TRUE

}
\seealso{
\code{\link[=xlt2qq]{xlt2qq()}} to convert a vector of UUIDs, IPv6
  addresses or other hexlets to QQIDs.
}
\author{
(c) 2019 \href{https://orcid.org/0000-0002-1134-6758}{Boris Steipe},
licensed under MIT (see file \code{LICENSE} in this package).
}
