% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xltIDexample.R
\name{xltIDexample}
\alias{xltIDexample}
\title{xltIDexample}
\usage{
xltIDexample(sel = 1:5)
}
\arguments{
\item{sel}{(numeric, logical, or character) a subsetting vector}
}
\value{
(character) a named vector of formatted hexlets.
}
\description{
\code{xltIDexample} returns synthetic, valid 128-bit numbers in hexadecimal
notation (hexlets) in different common formats. The synthetic examples are
easy to distinguish from "real" IDs to prevent their accidental use in an
application.
}
\details{
The function stores five artificial sample IDs. Input is a subsetting vector
that specifies which IDs to return. More than five IDs can be requested by
applying the usual subsetting rules. The IDs can be converted to the exact
same QQIDs provided by \code{\link[=QQIDexample]{QQIDexample()}}. The formats available are
\code{"md5"}: 32 hex numerals; \code{"hex"}: 32 hex numerals with \code{"0x"}
prefix; \code{"UUID"}: Universally Unique Identifier format; \code{"IPv6"}:
IPv6 formatted address; \code{"hEx"}: 32 hex numerals with mixed case.
}
\examples{
xltIDexample()                                  # the five stored hexlets
xltIDexample(2:3)                               # a hex number and a UUID
xltIDexample(c(TRUE, FALSE))                    # vector recycling
xltIDexample(sample(1:5, 17, replace = TRUE))   # seventeen in random order
xltIDexample("UUID") == qq2uu(QQIDexample(3))   # TRUE (correct conversion)

}
\seealso{
\code{\link[=QQIDexample]{QQIDexample()}} Returns five QQIDs
}
\author{
\href{https://orcid.org/0000-0002-1134-6758}{Boris Steipe} (aut)

(c) 2019 \href{https://orcid.org/0000-0002-1134-6758}{Boris Steipe},
licensed under MIT (see file \code{LICENSE} in this package).
}
