% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_qq_point.R
\name{stat_qq_point}
\alias{stat_qq_point}
\title{Quantile-quantile points}
\usage{
stat_qq_point(mapping = NULL, data = NULL, geom = "point",
  position = "identity", na.rm = TRUE, show.legend = NA,
  inherit.aes = TRUE, distribution = "norm", dparams = list(),
  detrend = FALSE, identity = FALSE, qtype = 7, qprobs = c(0.25,
  0.75), ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{distribution}{Character. Theoretical probability distribution function
to use. Do not provide the full distribution function name (e.g.,
\code{"dnorm"}). Instead, just provide its shortened name (e.g.,
\code{"norm"}). If you wish to provide a custom distribution, you may do so
by first creating the density, quantile, and random functions following the
standard nomenclature from the \code{stats} package (i.e., for
\code{"custom"}, create the \code{dcustom}, \code{pcustom},
\code{qcustom}, and \code{rcustom} functions).}

\item{dparams}{List of additional parameters passed on to the previously
chosen \code{distribution} function. If an empty list is provided (default)
then the distributional parameters are estimated via MLE. MLE for custom
distributions is currently not supported, so you must provide the
appropriate \code{dparams} in that case.}

\item{detrend}{Logical. Should the plot objects be detrended? If \code{TRUE},
the objects will be detrended according to the reference Q-Q line. This
procedure was described by Thode (2002), and may help reducing visual bias
caused by the orthogonal distances from Q-Q points to the reference line.}

\item{identity}{Logical. Only used if \code{detrend = TRUE}. Should an
identity line be used as the reference line for the plot detrending? If
\code{TRUE}, the points will be detrended according to the reference
identity line. If \code{FALSE} (default), the commonly-used Q-Q line that
intercepts two data quantiles specified in \code{qprobs} is used.}

\item{qtype}{Integer between 1 and 9. Only used if \code{detrend = TRUE} and
\code{identity =  FALSE}. Type of the quantile algorithm to be used by the
\code{\link[stats]{quantile}} function to construct the Q-Q line.}

\item{qprobs}{Numeric vector of length two. Only used if \code{detrend =
TRUE} and \code{identity =  FALSE}. Represents the quantiles used by the
\code{\link[stats]{quantile}} function to construct the Q-Q line.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
Draws quantile-quantile points, with an additional detrend option.
}
\examples{
# generate random Normal data
set.seed(0)
smp <- data.frame(norm = rnorm(100))

# Normal Q-Q plot of simulated Normal data
gg <- ggplot(data = smp, mapping = aes(sample = norm)) +
 stat_qq_point() +
 labs(x = "Theoretical Quantiles", y = "Sample Quantiles")
gg

# Exponential Q-Q plot of mean ozone levels (airquality dataset)
di <- "exp"
dp <- list(rate = 1)
gg <- ggplot(data = airquality, mapping = aes(sample = Ozone)) +
 stat_qq_point(distribution = di, dparams = dp) +
 labs(x = "Theoretical Quantiles", y = "Sample Quantiles")
gg

}
\references{
\itemize{
\item{\href{https://www.crcpress.com/Testing-For-Normality/Thode/p/book/9780824796136}{Thode,
H. (2002), Testing for Normality. CRC Press, 1st Ed.}}
}
}
