% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.r
\name{sampleFrac}
\alias{sampleFrac}
\title{Compute Sample Fractions}
\usage{
sampleFrac(n, nobsY = NULL, table = TRUE, study = " ")
}
\arguments{
\item{n}{integer vector, named with \code{"enrolled","randomized"} and optionally also including treatment levels.}

\item{nobsY}{a result of the the \code{nobsY} Hmisc function}

\item{table}{set to \code{TRUE} to return as an attribute \code{"table"} a character string containing an HTML table showing the pertinent frequencies created from \code{n} and the \code{denom} option, and if \code{nobsY} is present, adding another table with response variable-specific counts.}

\item{study}{character string with study ID}
}
\value{
named vector of relative sample sizes with an attribute \code{table} with frequency counts
}
\description{
Uses denominators stored with \code{setqreportOption} along with counts specified to \code{SampleFrac} to compute fractions of subjects in current analysis
}
\examples{
setqreportOption(tx.var='treatment', denom=c(enrolled=1000, randomized=800, a=398, b=402))
sampleFrac(getqreportOption('denom'))
}
