% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{vClus}
\alias{vClus}
\title{cClus}
\usage{
vClus(
  d,
  exclude = NULL,
  corrmatrix = FALSE,
  fracmiss = 0.2,
  maxlevels = 10,
  minprev = 0.05,
  horiz = FALSE,
  label = "fig-varclus",
  print = TRUE
)
}
\arguments{
\item{d}{a data frame or table}

\item{exclude}{formula or vector of character strings containing variables to exclude from analysis}

\item{corrmatrix}{set to \code{TRUE} to use \code{\link[Hmisc:plotCorrM]{Hmisc::plotCorrM()}} to depict a Spearman rank correlation matrix.}

\item{fracmiss}{if the fraction of \code{NA}s for a variable exceeds this the variable will not be included}

\item{maxlevels}{if the maximum number of distinct values for a categorical variable exceeds this, the variable will be dropped}

\item{minprev}{the minimum proportion of non-missing observations in a category for a binary variable to be retained, and the minimum relative frequency of a category before it will be combined with other small categories}

\item{horiz}{set to \code{TRUE} to draw the dendrogram horizontally}

\item{label}{figure label for Quarto}

\item{print}{set to \code{FALSE} to not let \code{dataframeReduce} report details}
}
\value{
nothing; makes Quarto tabs
}
\description{
Make Variable Clustering Quarto Report Section
}
\details{
Draws a variable clustering dendrogram and optionally graphically depicts a correlation matrix.  See \href{http://hbiostat.org/rflow/descript.html#describing-variable-interrelationships}{this} for an example.  Uses \code{\link[Hmisc:varclus]{Hmisc::varclus()}}.
}
\examples{
\dontrun{
vClus(mydata, exclude=.q(country, city))
}
}
\seealso{
\code{\link[Hmisc:varclus]{Hmisc::varclus()}}, \code{\link[Hmisc:plotCorrM]{Hmisc::plotCorrM()}}, \code{\link[Hmisc:upData]{Hmisc::dataframeReduce()}}
}
\author{
Frank Harrell
}
