% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_cards.R
\name{print_cards}
\alias{print_cards}
\title{print_cards}
\usage{
print_cards(qset, desc_col = "description", dir.print)
}
\arguments{
\item{qset}{"aqs" for Attachment Q-set (version 3.0) (Waters, 1995); "ccq"
for California Child Q-set (Block & Block, 1969); "mbqs" for Maternal
Behaviour Q-set (version 3.1) (Pederson et al., 1999); and "pq" for
Preschool Q-set (Baumrind, 1968 revised by Wanda Bronson).}

\item{desc_col}{Column name of qsets data frame containing item's
descriptions.}

\item{dir.print}{Directory path where .pdf file will be saved}
}
\value{
a pdf document with item’s descriptions displayed on separate cards.
}
\description{
print_cards creates a pdf document in a specified directory, with item’s
descriptions displayed on separate cards.
}
\examples{
\donttest{print_cards(qset = "aqs", desc_col = "description", dir.print = tempdir())}

}
\references{
Baumrind, D. (1968). Manual for the Preschool Behaviour Q-set.
 Parental Research Project. Berkeley, CA: Institute of Human Development,
 University of California.

 Block, J. H., & Block, J. (1969). The California Child Q-Set. Berkeley, CA:
 Institute of Human Development, University of California.

 Pederson, D. R., Moran, G., & Bento, S. (1999). Maternal Behaviour Q-sort
 (version 3.1). London, ON: Psychology Department, Western University.

 Waters, E. (1995). Appendix A: The attachment Q-set (Version 3. 0).
 Monographs of the Society for Research in Child Development, 60, 234-246.
}
