% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetricPolynomials.R
\name{isSymmetricQspray}
\alias{isSymmetricQspray}
\title{Check symmetry of a polynomial}
\usage{
isSymmetricQspray(qspray)
}
\arguments{
\item{qspray}{a \code{qspray} polynomial}
}
\value{
A Boolean value indicating whether the polynomial defined by 
  \code{qspray} is symmetric.
}
\description{
Check whether a \code{qspray} polynomial is symmetric.
}
\examples{
e1 <- ESFpoly(3, 1)
e2 <- ESFpoly(3, 2)
e3 <- ESFpoly(3, 3)
q <- e1 + 2*e2 + 3*e3 + 4*e1*e3
isSymmetricQspray(q)
}
\seealso{
\code{\link{MSPcombination}}, \code{\link{compactSymmetricQspray}}
}
