% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_sdp.R
\name{invert_sdp}
\alias{invert_sdp}
\title{Calculate SNP genotype matrix from strain distribution patterns}
\usage{
invert_sdp(sdp, n_strains)
}
\arguments{
\item{sdp}{Vector of strain distribution patterns (integers between
1 and \eqn{2^n-2} where \eqn{n} is the number of strains.}

\item{n_strains}{Number of strains}
}
\value{
Matrix of SNP genotypes, markers x strains, coded as 1
(AA) and 3 (BB). Markers with values other than 1 or 3 are omitted,
and monomorphic markers, are omitted.
}
\description{
Calculate the matrix of SNP genotypes from a vector of strain distribution patterns (SDPs).
}
\examples{
sdp <- c(m1=1, m2=12, m3=240)
invert_sdp(sdp, 8)
}
\seealso{
\code{\link[=sdp2char]{sdp2char()}}, \code{\link[=calc_sdp]{calc_sdp()}}
}
