% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_pvl.R
\name{boot_pvl}
\alias{boot_pvl}
\title{Perform bootstrap sampling and calculate test statistics for each bootstrap sample}
\usage{
boot_pvl(probs, pheno, addcovar = NULL, kinship = NULL,
  start_snp = 1, n_snp, pleio_peak_index, nboot_per_job = 1,
  max_iter = 10000, max_prec = 1/1e+08, n_cores = 1)
}
\arguments{
\item{probs}{founder allele probabilities three-dimensional array for one chromosome only (not a list)}

\item{pheno}{n by d matrix of phenotypes}

\item{addcovar}{n by c matrix of additive numeric covariates}

\item{kinship}{a kinship matrix, not a list}

\item{start_snp}{positive integer indicating index within probs for start of scan}

\item{n_snp}{number of (consecutive) markers to use in scan}

\item{pleio_peak_index}{positive integer index indicating genotype matrix for bootstrap sampling. Typically acquired by using `find_pleio_peak_tib`.}

\item{nboot_per_job}{number of bootstrap samples to acquire per function invocation}

\item{max_iter}{maximum number of iterations for EM algorithm}

\item{max_prec}{stepwise precision for EM algorithm. EM stops once incremental difference in log likelihood is less than max_prec}

\item{n_cores}{number of cores to use when calling `scan_pvl`}
}
\value{
numeric vector of (log) likelihood ratio test statistics from `nboot_per_job` bootstrap samples
}
\description{
Create a bootstrap sample, perform multivariate QTL scan, and calculate LRT statistic
}
\details{
Performs a parametric bootstrap method to calibrate test statistic values in the test of
pleiotropy vs. separate QTL. It begins by inferring parameter values at
the `pleio_peak_index` index value in the object `probs`. It then uses
these inferred parameter values in sampling from a multivariate normal
distribution. For each of the `nboot_per_job` sampled phenotype vectors, a two-dimensional QTL
scan, starting at the marker indexed by `start_snp` within the object
`probs` and extending for a total of `n_snp` consecutive markers. The
two-dimensional scan is performed via the function `scan_pvl`. For each
two-dimensional scan, a likelihood ratio test statistic is calculated. The
outputted object is a vector of `nboot_per_job` likelihood ratio test
statistics from `nboot_per_job` distinct bootstrap samples.
}
\examples{

probs_pre <- rbinom(n = 100 * 10, size = 1, prob = 1 / 2)
probs <- array(data = probs_pre, dim = c(100, 1, 10))
s_id <- paste0('s', 1:100)
rownames(probs) <- s_id
colnames(probs) <- 'A'
dimnames(probs)[[3]] <- paste0('Marker', 1:10)
# define Y
set.seed(2018-12-29)
Y_pre <- runif(200)
Y <- matrix(data = Y_pre, nrow = 100)
rownames(Y) <- s_id
colnames(Y) <- paste0('t', 1:2)
addcovar <- matrix(c(runif(99), NA), nrow = 100, ncol = 1)
rownames(addcovar) <- s_id
colnames(addcovar) <- 'c1'
kin <- diag(100)
rownames(kin) <- s_id
colnames(kin) <- s_id
Y2 <- Y
Y2[1, 2] <- NA
boot_pvl(probs = probs, pheno = Y, kinship = kin,
        start_snp = 1, n_snp = 10, pleio_peak_index = 10, nboot_per_job = 1)
boot_pvl(probs = probs, pheno = Y2, kinship = kin,
        start_snp = 1, n_snp = 10, pleio_peak_index = 10, nboot_per_job = 2)


}
\references{
Knott SA, Haley CS (2000) Multitrait
least squares for quantitative trait loci detection.
Genetics 156: 899–911.

Walling GA, Visscher PM, Haley CS (1998) A comparison of
bootstrap methods to construct confidence intervals in QTL mapping.
Genet. Res. 71: 171–180.
}
