% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_multi_onechr.R
\name{scan_multi_oneqtl_perm}
\alias{scan_multi_oneqtl_perm}
\title{Permute the phenotypes matrix and then scan the genome. Record the genomewide greatest LOD score for each permuted data set.}
\usage{
scan_multi_oneqtl_perm(
  probs_list,
  pheno,
  kinship_list = NULL,
  addcovar = NULL,
  n_perm = 1,
  cores = 1
)
}
\arguments{
\item{probs_list}{a list of founder allele probabilities, one array per chromosome}

\item{pheno}{a matrix of trait values}

\item{kinship_list}{a list of kinship matrices, one per chromosome}

\item{addcovar}{a matrix of covariate values}

\item{n_perm}{positive integer for the number of permuted data sets to scan.}

\item{cores}{number of cores for parallelization}
}
\value{
a vector of `n_perm` max lod statistics
}
\description{
Permute the phenotypes matrix and then scan the genome. Record the genomewide greatest LOD score for each permuted data set.
}
