
//******************************************************************************************
//*******************************************************************************************

#ifndef BMQ_MCMC_H
#define BMQ_MCMC_H


// these are global parameters, which values have been generated by the previous steps

extern int CROSS;         // cross type 0:RILs, 1:BC, 2:F2
extern int NG;            // number of genotypes
extern int NLG;           // number of chromosomes
extern int NS;            // number of individuals 
extern double **GRID;     // grid points
extern double ****QPROB;  // genotype probabilities for each individual at each grid

extern int TNGRID;        // total number of grids
extern int *NGRID;        // number of grids at each chromosome
extern int CHL;           // max number of grids 

extern int NS1;           // number of individuals 

//*****************************************************************************************
// these parameters are passed from R function bmq.mcmc

extern double *Y;             // phenotypic data
extern int CATEGORY;          // 1: normal data; 2: binary data; 3:ordinal data
extern int CN;                // Categories # for binary or ordinal data

extern int NITER;             // Number of iterations
extern int NTHIN;             // Thinning value
extern int NBURNIN;            // Burnin
extern int VERBOSE;           // Verbose

extern int GIBBS;             // 1: Gibbs scaning all effects; 0: Kohn's M-H method for MCMC algorithm
extern int UPDATEGENO;        // 1: update QTL genotypes; 0: doesn't update QTL genotype

extern int EPISTASIS;         // 1: epistatic model; 0: non-epistatic model;
extern int E_NQTL_MAIN;    // expected number of main-effect QTL 
extern int E_NQTL;         // expected number of all QTL 
extern int NQTL;              // max QTL #  

extern double *DQQ;            // distance between flanking two genes 
extern int *CHR_NQTL;         // max QTL # at each chromosome

extern int ENV_FACTOR;        // 1:include environmental factors-need to fix this
extern int GBYE;              // 1: include g by e interactions
extern int NRANCOVA;          // random effects #
extern int NFIXCOVA;          // fixed effects # 
extern int *GBYE_FIX_INDEX;   // indicating which fixed covariates are treated in g-by-e
extern int *NRAN;             // random effect #
extern double **COEF_RAN;     // random covariates
extern double **COEF_FIX;      // fixed covariates

extern int DEPENDENCE;        // see Chipman's paper
extern double *C;             // see Chipman's paper 

extern int SEED;		      // the pseudo-random number generator

//********************************************************************************
 
extern int GROUP;             // 1: groupedly update all main effects or epistatic effects
extern int NC;                // the number of main effects at one QTL

extern int SPH;               // 1: standardized phenotype; 0: original phenotype

//********************************************************************************
// for binary and ordinal traits

extern int *W;                // ordinal or binary phenotype
extern double *CUTPOINT;      // threshold values for ordinal traits

//********************************************************************************
// parameters used in prior specification

extern double W_MAIN;          // prior for main effect indicator
extern double W_EPISTASIS;     // prior for epistatic effect indicator
extern double W_GBYE;          // prior for g by e indicator
extern double  *VMAIN;         // prior variance of main effects
extern double **VEPISTASIS;    // prior variance of epistatic effects
extern double **V_GBYE_FIX;    // prior variance of g-by-e effects

//*********************************************************************************
// genetic model parameters

extern double AMU;             // overall mean
extern double VE;              // residual variance
extern double  **MAIN;         // main effects
extern double ****EPISTATIC;   // epistatic effects

extern double *GVALUE;         // genotypic valyes
extern int **GENO;             // QTL genotypes
extern double ***COEF;         // coefficients of QTL main effects

//*********************************************************************************
// QTL positions, genetic effects indicators

extern int *QLOC;             // QTL position indicators, position is GRID[QCHR[L]][QLOC[L]] 
extern int *QCHR;             // chromosomes that QTL locate
extern int *CHRQTL;           // QTL number at each chromosome 

extern int *GAMMA;            // QTL indicators
extern int *GAMMA_MAIN;       // main effects indicators
extern int **GAMMA_EPISTASIS; // epistatic effects indicators 

//**********************************************************************************
// environmental covariate parameters

extern double  *FIX;         // effects of fixed covariates 
extern double  **RAN;        // effects of random covariates
extern double  *VRAN;        // variances of random covariates
extern double ***GBYE_FIX;   // interactions of QTL main effects and fixed covariates
extern double  **GAMMA_GBYE; // g-by-e indicators

//***********************************************************************************

extern double PDD1, PDD2;
extern double *PD1, *PD2;

extern int IBD;

extern double  *X;

//*************************************************************************************************************

extern char iterfile[100];
extern char pairfile[100];
extern char mainfile[100];
extern char gbyefile[100];
extern char covfile[100];
 
//*****************************************************************************************************
void R_AnalysisEngine(int *nind,int *nchr,int *ngen, int *nloci,double *loci,double *prob,
					  double *yvalue,int *traittype,int *ncategory,
					  int *iter,int *thin,int *burnin,
                      int *algorithm,int *genoupdate,
                      int *epis,int *emainqtl,int *eqtl,int *mnqtl,
					  double *interval,int *chrnqtl,
					  int *envi,int *qtl_envi,int *nrancov,int *nfixcov,int *intcov,double *rancoef,double *fixcoef,int *nran,
					  int *depen,double *prop,int *seed,
		              int *verbose); 

//******************************************************************
// C functions included  
  
double RANDOM();

void ANORMAL(double *R1,double *R2);

void MULTINORMAL(double * PRIOR);

double NormalFunction(double X);

double TrunNormal(int WW,double B,double V);

double Likelihood(double *p,double *G);

void Coefficient(int GENOTYPE);

void Coefficient0(int I,int L,int QL);

double GenotypeSampling(int I,int L,int II,int QL);

void Mean(double YBAR,double VP);

void ResidualVariance();

void MainEffect(int L);

void EpistaticEffect(int L1,int L2);

void GBYE_FixedCovariate(int L1,int L2);

void MainVariance(double VP);

void EpistaticVariance(double VP);

void GBYE_FixedCovariate_Variance(int L1,double VP);

void FixedCovariate(int L);

void RandomCovariate(int L);

void RanVariance(int L,double VP);

void QTLgenotype(int L,int NL,int QL,int I);

void QTLINHERITANCE(int L,int I);

void QTLPOSITION(int L,int QLNEW);

int SamplingOnePosition(int L);

void ZeroEffect();
void ZeroEffect1(int L);
void ZeroEffect2(int L1,int L2);

void MainEffectIndicator_GROUP0(int L,int K);

void MainEffectIndicator_GROUP1(int L);

void EpistasisIndicator_GROUP0(int L1,int L2,int K1,int K2);

void EpistasisIndicator_GROUP1(int L1,int L2);

void GBYE_FIX_Indicator_GROUP0(int L1,int L2,int K);

void GBYE_FIX_Indicator_GROUP1(int L1,int L2);

//******************************************************************

void bmqAnalysis();

#endif //BMQ_MCMC_H
