% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\alias{summary.qtlpoly.fitted}
\title{Fits multiple QTL models}
\usage{
fit_model(
  data,
  model,
  probs = "joint",
  polygenes = "none",
  keep = TRUE,
  verbose = TRUE,
  pheno.col = NULL
)

\method{summary}{qtlpoly.fitted}(object, pheno.col = NULL, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{model}{an object of class \code{qtlpoly.profile} or \code{qtlpoly.remim}.}

\item{probs}{a character string indicating if either \code{"joint"} (genotypes) or \code{"marginal"} (parental gametes) conditional probabilities should be used.}

\item{polygenes}{a character string indicating if either \code{"none"}, \code{"most"} or \code{"all"} QTL should be used as polygenes.}

\item{keep}{if \code{TRUE} (default), stores all matrices and estimates from fitted model; if \code{FALSE}, nothing is stored.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if
\code{FALSE}, no output is produced.}

\item{pheno.col}{a numeric vector with the phenotype column numbers to be summarized; if \code{NULL} (default), all phenotypes from \code{'data'} will be included.}

\item{object}{an object of class \code{qtlpoly.fitted} to be summarized.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.fitted} which contains a list of \code{results} for each trait with the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{fitted}{a \pkg{sommer} object of class \code{mmer}.}
    \item{qtls}{a data frame with information from the mapped QTL.}
}
\description{
Fits alternative multiple QTL models by performing variance component estimation using REML.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Search for QTL
  remim.mod = remim(data = data, pheno.col = 1, w.size = 15, sig.fwd = 0.0011493379,
sig.bwd = 0.0002284465, d.sint = 1.5, n.clusters = 1)

  # Fit model
  fitted.mod = fit_model(data=data, model=remim.mod, probs="joint", polygenes="none")
  }

}
\references{
Covarrubias-Pazaran G (2016) Genome-assisted prediction of quantitative traits using the R package sommer. \emph{PLoS ONE} 11 (6): 1–15. \doi{10.1371/journal.pone.0156744}.

    Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{read_data}}, \code{\link[qtlpoly]{remim}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
