% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_weight.R
\name{tfidf}
\alias{tfidf}
\title{compute tf-idf weights from a dfm}
\usage{
tfidf(x, normalize = FALSE, scheme = "inverse", ...)
}
\arguments{
\item{x}{object for which idf or tf-idf will be computed (a document-feature 
matrix)}

\item{normalize}{if \code{TRUE}, use relative term frequency}

\item{scheme}{scheme for \code{\link{docfreq}}}

\item{...}{additional arguments passed to \code{\link{docfreq}} when calling
\code{tfidf}}
}
\description{
Compute tf-idf, inverse document frequency, and relative term frequency on 
document-feature matrices.  See also \code{\link{weight}}.
}
\details{
\code{tfidf} computes term frequency-inverse document frequency 
  weighting.  The default is not to normalize term frequency (by computing 
  relative term frequency within document) but this will be performed if 
  \code{normalize = TRUE}.
}
\examples{
head(data_dfm_LBGexample[, 5:10])
head(tfidf(data_dfm_LBGexample)[, 5:10])
docfreq(data_dfm_LBGexample)[5:15]
head(tf(data_dfm_LBGexample)[, 5:10])

# replication of worked example from
# https://en.wikipedia.org/wiki/Tf-idf#Example_of_tf.E2.80.93idf
(wikiDfm <- new("dfmSparse", 
                Matrix::Matrix(c(1,1,2,1,0,0, 1,1,0,0,2,3),
                   byrow = TRUE, nrow = 2,  
                   dimnames = list(docs = c("document1", "document2"), 
                     features = c("this", "is", "a", "sample", "another",
                                  "example")), sparse = TRUE)))
docfreq(wikiDfm)
tfidf(wikiDfm)
}
\references{
Manning, C. D., Raghavan, P., & Schutze, H. (2008). 
  \emph{Introduction to Information Retrieval}. Cambridge University Press.
}
\keyword{dfm}
\keyword{internal}
\keyword{weighting}
