% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-versions.R
\name{check_newer_version}
\alias{check_newer_version}
\title{Check for newer version of Quarto}
\usage{
check_newer_version(version = quarto_version(), verbose = TRUE)
}
\arguments{
\item{version}{Character string specifying the Quarto version to check.
Defaults to the currently installed version detected by \code{\link[=quarto_version]{quarto_version()}}.
Use "99.9.9" to indicate a development version.}

\item{verbose}{Logical indicating whether to print informational messages.
Defaults to \code{TRUE}. When \code{FALSE}, the function runs silently and only
returns the logical result.}
}
\value{
Invisibly returns a logical value:
\itemize{
\item \code{TRUE} if an update is available
\item \code{FALSE} if no update is needed or when using development version
The function is primarily called for its side effects of printing
informational messages (when \code{verbose = TRUE}).
}
}
\description{
Checks if a newer version of Quarto is available and informs the user about
their current version status. The function compares the current Quarto version
against the latest stable and prerelease versions available online.
}
\details{
The function handles three scenarios:
\itemize{
\item \strong{Development version} (99.9.9): Skips version check with informational message
\item \strong{Prerelease version}: Compares against latest prerelease and informs about updates
\item \strong{Stable version}: Compares against latest stable version and suggests updates if needed
}

Version information is fetched from Quarto's download JSON endpoints and cached in current session
for up to 24 hours to avoid repeated network requests.
}
\section{Network Requirements}{

This function requires an internet connection to fetch the latest version
information from quarto.org. If the network request fails, an error will be thrown.
}

\examples{
\dontshow{if (quarto::quarto_available() && quarto:::has_internet("https://www.quarto.org")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check current Quarto version
check_newer_version()

# Check a specific version
check_newer_version("1.7.30")

# Check development version (will skip check)
check_newer_version("99.9.9")

# Check silently without messages
result <- check_newer_version(verbose = FALSE)
if (result) {
  message("Update available!")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=quarto_version]{quarto_version()}} for getting the current Quarto version,
}
