% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal_kernels.R
\name{k_weibull}
\alias{k_weibull}
\title{Dispersal kernels for Weibull distance distributions}
\usage{
k_weibull(x, par, N = 1, d = NCOL(x))
}
\arguments{
\item{x}{Numeric matrix of positions \eqn{x} relative to the seed source,
or vector of distances \eqn{\left\|{x}\right\|} to the seed source.}

\item{par}{Numeric vector with two elements representing the
log-transformed scale and shape parameters \eqn{a} and \eqn{b} of the
distance distribution.}

\item{N}{The multiplier \eqn{N}.}

\item{d}{The spatial dimension.}
}
\value{
Numeric vector of function values \eqn{k(x)} multiplied by \eqn{N}.
}
\description{
\code{k_weibull} computes the value, multiplied by \eqn{N}, of the dispersal
kernel from Tufto et al. (1997) based on seeds having a distance with a
Weibull distribution from their source.
}
\details{
The dispersal kernel, i.e. spatial probability density
of the location of a seed relative to its source, is here given by
\deqn{k(x)={b\Gamma (d/2) \over 2\pi ^{d/2}a^{b}}\left\|{x}\right\|^{b-d}
  e^{-(\left\|{x}\right\|/a)^{b}},}
which corresponds to a probability density of the distance given by
\deqn{p(r)={b \over a^{b}}r^{b-1}e^{-(r/a)^{b}},}
where \eqn{d} is the spatial dimension, \eqn{\left\|{\,}\right\|}
denotes the Euclidean norm and the normalizing constants involve the
\link[base:gamma]{gamma} function; see Tufto et al. (1997) for the planar
case. Thus, the distance is assumed to have the
\link[stats:Weibull]{Weibull distribution} with scale parameter \eqn{a}
and shape parameter \eqn{b}. Equivalently, the \eqn{b}th power of the
distance has an exponential distribution with scale parameter \eqn{a^{b}}.

Consequently, if and only if \eqn{b<1}, the distance distribution has
a heavier tail than an exponential distribution, although with tail
probabilities still decreasing faster than any power law; it is a
fat-tailed distribution in the sense of Kot et al. (1996). The kernel
coincides with a Gaussian kernel in the special case \eqn{b=d=2}.
}
\examples{
k_weibull(2:5, par=c(0,0), d=2)
}
\references{
Tufto, J., Engen, S., Hindar, K. (1997). Stochastic dispersal processes in
plant populations, \emph{Theoretical Population Biology} \strong{52}(1), 16–26.
\doi{10.1006/tpbi.1997.1306}

Austerlitz, F., Dick, C.W., Dutech, C., Klein, E.K., Oddou-Muratorio, S.,
Smouse, P.E., Sork, V.L. (2004). Using genetic markers to estimate the
pollen dispersal curve. \emph{Molecular Ecology} \strong{13}, 937–954.
\doi{10.1111/j.1365-294X.2004.02100.x}

Kot, M., Lewis, M.A., van den Driessche, P. (1996). Dispersal Data and the
Spread of Invading Organisms. \emph{Ecology} \strong{77(7)}, 2027–2042.
\doi{10.2307/2265698}

Nathan, R., Klein, E., Robledo‐Arnuncio, J.J., Revilla, E. (2012).
Dispersal kernels: review, in Clobert, J., Baguette, M., Benton, T.G.,
Bullock, J.M. (eds.), \emph{Dispersal ecology and evolution}, 186–210.
\doi{10.1093/acprof:oso/9780199608898.003.0015}
}
